unit Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  LibXmlParser, LibXmlComps, ComCtrls, StdCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    TreeView: TTreeView;
    XmlScanner: TXmlScanner;
    procedure Button1Click(Sender: TObject);
    procedure XmlScannerStartTag(Sender: TObject; TagName: String;
      Attributes: TAttrList);
    procedure XmlScannerEndTag(Sender: TObject; TagName: String);
  private
    { Private-Deklarationen }
  public
    FrankfurtNode : TTreeNode;
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Button1Click(Sender: TObject);
begin
  TreeView.Items.Clear;
  FrankfurtNode := nil;
  XmlScanner.Execute;
end;

procedure TForm1.XmlScannerStartTag(Sender: TObject; TagName: String;
  Attributes: TAttrList);
var
  Node : TTreeNode;
  Text : string;
  I    : integer;
begin
  Text := TagName;
  for I := 0 to Attributes.Count-1 do
    Text := Text + ' ' + Attributes.Name (I) + '=' + Attributes.Value (I);
  Node := TreeView.Items.AddChild (FrankfurtNode, Text);
  FrankfurtNode := Node;
end;

procedure TForm1.XmlScannerEndTag(Sender: TObject; TagName: String);
begin
  FrankfurtNode := FrankfurtNode.Parent;
end;

end.
